// This is Minidalek version 33                                              12/9/2025
//***************************************************************************************

    // TO ENABLE SPEED ADJUST POT:
    // Create folder named "10-settings" on your SD card(from the DF-Player)
    //
    // Place an MP3 with a name starting with "100-speedPOT". 
    // You can add to end of this name if desired



    // TO ENABLE SPEED ADJUST WITHOUT A POT: 
    // Create folder named "10-settings" on your SD card(from the DF-Player)
    //
    // Place an MP3 with a name starting with "101-speedPICK". 
    // You can add to end of this name if desired
    // 100-speedpot must not exist (rename it to x100-speedpot)
    //
    // Now name another MP3 with a name between 050 and 099 to indicate your speed setting.
    // There may already be a file named  "x060-speed has been set.mp3" that you can remove
    // the "x" and change the 3 digits to your desired speed adjust setting.
   


    // TO ENABLE ALTERNATE BRAKE SETTING: (normally not needed...some of us are not normal)
    // Some motor drivers like the XY-160d require IN1 and IN2 to be set to 00 for braking.
    // The TB6612FNG uses 00 for stop and 11 for brake. We dont use brakes on the minidalek.
    //
    // Place an MP3 with a name starting with "102-brake00" in the folder named "10-settings" 
    // on your SD card (from the DF-Player).



/*
DF Player Mini info:

1 .The default  folders are  named  as "00", "11", “99” in  this  way. It is
made to support maximum 100 folders and maximum 255 tracks in each folder.
Tracks are named "001" through "255" and may be .mp3 or .wav

2. For example, to specify and play “100-filename.mp3” in the folder "01", 
     send the command 7E FF 06 0F 00 01 64 EF  
     or in decimal 126,255,6,15,0,1,100,239
  MSB: 6th byte represents the name of the folder, supports 99 folders from 00-99
  LSB: 7th byte represents the track, supports 255 tracks from 0x01 to 0xFF

3. You must specify both the folder and the file name to target a track. 
   This feature supports MP3 and WAV audio formats.
*/



//sound info for sketch version 29 and higher
//
// All audio files are stored on the Micro SD card inserted in the DFPlayer Mini module
// Sound files can be either MP3 or WAV files
//
// Sounds are stored in folder named 00 (you can append to name: 00-sound files  or anything after the 00)
//
// Sound files must be named starting with 3 digits from 001-255 and placed in 00 folder
//   example:  005-exterminate.mp3
//
//
//
// there are 4 audio modes (for now)
//
// servo mode - down, X button and PS button (just a few sounds - least annoying) 
// dpad mode - right, left, down, X and ps button (many sounds - beast mode!)
// ps mode - X, down, ps button  (some sounds - OK for kids)
// r2d2 mode - enable this by holding Button1 while booting or install jumper by Button1
//
//
// press up arrow 12 times to enable Dpad key sounds and disable servo mode- DONT TELL THE KIDS
// (up arrow 12 more times returns to servo mode from Dpad mode)
//
//   right - cycles through 15 sounds named (201-215 if dpad*) (170 if PSmode*)
//   left  - (replay right arrow sound if dpad*) (175 if PSmode*)
//   
//   up    - plays sound named (216 if dpad)
//           works 3 times until you press another button
//
//   down  - plays sound named (220 if servo*) (221-222 if dpad*) (223 if PS*) 
//           works once until you press another button

//
// press down arrow 12 times to enable round PlayStation button(PSmode)- DONT TELL THE KIDS
// (down arrow 12 more times returns to servo mode from PSmode)
//
//   PS    - cycles through sounds (224 if servo) (225-229 if PSmode*) (230-250 if dpad) ear lights
//           (sound 011 if r2d2)
//
//   X     - (sound 140-143 if servo*) (sound 150-159 if dpad*) (sound 160-164 if PSmode*) - gun light 
//           (sound 038-050 if r2d2*)
//
// 012 - Red circle button (r2d2 mode gun)	
// 013 - Red circle button (machine gun)
// 015 - Trigger button (Pew gun)
// 016 - Trigger button (r2d2 Pew gun)
// 008 - L1 button (r2d2 mode)its a trap (cycle through 008-010)
// 005 - L1 button (exterminate)
// 190 - dpadMode announcement
// 191 - psMode announcement
// 192 - servoMode announcement
// 193 - dalekMode announcement
// 194 - r2d2Mode announcement
// 195 - Adjustable speed announcement
//
//        * ignore the asterisk

#include <HardwareSerial.h>
#include <Ps3Controller.h>
#include <Wire.h>

#define miniDalekVersion 33

#define pwm_M1 21 // PWM output pin 21 for motor 1 control
#define pwm_M2 18 // PWM output pin 18 for motor 2 control
#define pwm_Gun 27
#define pwm_Ear 26
#define pwm_Servo 19

#define Motor1a 32 // direction i/o pins
#define Motor1b 33
#define Motor2a 22
#define Motor2b 23

#define DalekMode 1
#define R2D2Mode 2

#define PWMoff 0
#define PWMlow 3    //blaster brightness
#define PWMmed 15
#define PWMhigh 100

#define EARoff 0
#define EARlow 0   //ear light brightness
#define EARmed 3
#define EARhigh 12


#define earLED  26      // gpio26
#define gunLED  27
#define Jumper14 14
#define Button1 13
#define Button2 12
#define volumePin 25      // dont use 14 - analog messes with uart2??? maybe?

#define TXD2 17
#define RXD2 16
#define BAUD_D2 9600

// Create an instance of the HardwareSerial class for Serial2 to control DFplayer
HardwareSerial SerialDF(2);


#define Start_Byte 0x7E
#define Version_Byte 0xFF
#define Command_Length 0x06
#define End_Byte 0xEF
#define Acknowledge 0x00 //Returns info with command 0x41 [0x01: info, 0x00: no info]


#define speaker 26    // for direct to speaker sounds

// joystick range - may not be current
// forward -26 to -128
// stop    -25 to 25   reserved stop center postition
// reverse  26 to 128
//
//
// PWM control range - old data from L293D ??
// 0     -   motor off
// 1 to 174 	motor stalled
// 175 to 255 	motor on
//
//

// TB6612FNG dual motor driver
//
//  1 - Vm (+6v)Gnd     (D21)pwmA - 8      (D32)Ain1(HIGH) and (D33)Ain2(LOW) = Motor1 forward       
//  2 - Vcc (+3.3v)     (D33)Ain2 - 7      (D32)Ain1(LOW)  and (D33)Ain2(HIGH)= Motor1 reverse
//  3 - Gnd             (D32)Ain1 - 6      (D32)Ain1(LOW)  and (D33)Ain2(LOW) = Motor1 OFF
//  4 - MOTa1   (Vcc for now)Stby - 5      (D32)Ain1(HIGH) and (D33)Ain2(HIGH) = Motor1 brake
//  5 - MOTa2           (D23)Bin1 - 4      (D23)Bin1(HIGH) and (D22)Bin2(LOW)  = Motor2 forward
//  6 - MOTb1           (D22)Bin2 - 3      (D23)Bin1(LOW)  and (D22)Bin2(HIGH) = Motor2 reverse
//  7 - MOTb2           (D18)pwmB - 2      (D23)Bin1(LOW)  and (D22)Bin2(LOW)  = Motor2 OFF
//  8 - Gnd                    Gnd- 1      (D23)Bin1(HIGH) and (D22)Bin2(HIGH)  = Motor2 brake
//                                            Stby(LOW) or disconnected = both motors OFF

// DFplayer mini - MP3 player
//
//  1 - Vcc (5v -ESP32 VIN)   BUSY(D35) - 16
//  2 - RX (D17)                   USB- - 15
//  3 - TX                         USB+ - 14
//  4 - DAC_R                    ADKEY1 - 13
//  5 - DAC_L                    ADKEY2 - 12
//  6 - SPK1-                       IO2 - 11
//  7 - GND                         GND - 10
//  8 - SPK2+                       IO1 -  9



// optional - speed control pot  (if your bot goes too fast or slow)
//                                 _____         (A) ----\/\/\/\/\/\---- (B)
//  (A)   Neg Ground (black) ==== /     \                     ^
//  (B)output to D15(yellow) ====(  (-)  )                    |
//  (C)       Pos 3.3V (red) ==== \_____/                     |
//                          [front or top view]              (C)
//                                       
//  Connect it wrong and you may see smoke!
//
// D15 is on ESP-X1 at pin closest to USB connector
// Solder in a 4pin header on BLACK PC board
// On newer boards, its under the ESP-32, use wires


int busyPin = 35;
unsigned long musicMillis;
unsigned long trackMillis;
unsigned long chkMillis;
unsigned long gunMillis;
unsigned long extermMillis=0;   // limit time between saying EXTERMINATE
unsigned long mgunMillis=0;    // limit time between firing machine gun
unsigned long wakeupMillis;   // make some noise after 10 minutes of no activity


bool tooShort;
int mp3Busy=0;
int t_debug=false;

int mp3_r2d2 = 0;    // first r2d2 mp3
int PSmp3=0;  // first PSMODE mp3
int PSmp3DP=0;
int DPADmp3=0;
int crossMp3=0;

int prevTrack=0;
int prevFolder=0;

int upPressed=false;
int upPlayed=false;
int downPressed=false;
int downPlayed=false;
int rightPressed=false;
int rightPlayed=false;
int leftPressed=false;
int leftPlayed=false;
int psPressed=false;


int gunLoop;
int LED_on;
int gunReset = false;
int gunShooting = false;
int noMatch;

int Volume = 0;
int dfVolume;
int lastVolume = 1;

int pot2Div;
int pot2Value =0;
int pot2Pin=15;

int brake00 = false;

int lastX=2;
int lastY=2;
int stickY;
int stickX;

int qq = 0;
int qqq=0;
int qqt=0;

int moving = false;

int servoPos=0;
int servoMode=true;
int psMode=false;
int dpadMode=false;
int downCount=0;
int crossCount=0;
int upCount=0;

int busy=LOW;

//float joyUnits = ((255.0-175)/(128 - 25.0));   // L293D

// motor wont spin below 45 duty cycle
// PWM range 0(off) to 255(full on)
//
// joystick range is -128 to 0 to 128
//   
// we dont run motors between -20 and 20 from joystick
// to allow for generous center off 
//

float joyUnits = ((255.0-45)/(128-20.0));      // TB6612FNG
int setPWM;
int turnPWM;

float defaultRotateSpeed=.95;
float rotateSpeed=.95;
//float defaultRotateSpeed=.87;
//float rotateSpeed=.87;
float speedAdjust= 0.99;

int adjustableSpeed = false;

int topSpeedOffset = 6;       // 6 = 255 PWM

int speedPick=0;

//int pwm_channel = 0;
int pwm_freq = 25000;
int pwm_res = 8;

int RC_mode;  // Dalek or R2D2

unsigned long time_now = 0;
int qqqq=0;


void setup()
{
    Serial.begin(115200);
    delay(1000);

  
    // Start Serial 2 with the defined RX and TX pins and a baud rate of 9600
    SerialDF.begin(9600, SERIAL_8N1, RXD2, TXD2);
	  delay(2000);
    //playtrk(0,15);     //single gun blast (pew)
        
    pinMode(Button1,INPUT_PULLUP);
    pinMode(Button2,INPUT_PULLUP);
    pinMode(Jumper14,INPUT_PULLUP);


    pinMode(busyPin, INPUT);   //  Mp3 busy playing sound


    // Set DFplayer volume pot range  0 to 4095
    // converted to required level 0-30
    
    // dump first read - needs to initialize io (maybe)
    Volume = analogRead(volumePin);
    delay(100);
    Serial.println("Serial 2 started at 9600 baud rate");
	  Serial.print("  Mini Dalek version=");
    Serial.println(miniDalekVersion);

    Volume = analogRead(volumePin);
    dfVolume = int(Volume/136);
      Serial.print("  154 -   Volume=");
      Serial.print(Volume);
      Serial.print("  dfVolume=");
      Serial.println(dfVolume);
      delay(250);

    volume_CMD(0x06,0,dfVolume);  //set volume - playtrk does this
    delay (250);
    checkTrk(10,100);
    delay(500);
//playtrk(0,50);
//delay(3000);
//playtrk(0,201);
//delay(3000);
//playtrk(10,100);
//delay(3000);
    //  To enter speed adjust pot:
    //    You must install a potentiometer connected to GPIO-35, outer pins to +3.3v and GND
    //    There must be a valid MP3 track in folder 10 named 100
    //
    pinMode(pot2Pin, INPUT);
    pot2Value = analogRead(pot2Pin);
    Serial.print("  Pot2 Value=");
    Serial.print(pot2Value);
    if(checkTrk(10,100)){
      adjustableSpeed = true;
      speedAdjust = (float)pot2Value/2469.0;
      speedAdjust = (speedAdjust/2.0)+0.16;
    }

    if (adjustableSpeed==false){   // is speed pot installed?
      if (checkTrk(10,101)){          // no speed pot - is custom speed selected?
        speedPick = 99;
        while ((checkTrk(10,speedPick)==false) && (speedPick>20)){
          --speedPick;
        }
        if (speedPick==20){
          Serial.println("error:  no speedpick entered - using default of 99:");
          speedPick=99;
        }
        speedAdjust=speedPick / 100.0;
        Serial.print("speedPick=");
        Serial.print(speedPick);
        Serial.print("   speedAdjust=");
        Serial.print(speedAdjust);
        delay(4000);
      }
    }

    if (speedAdjust<0.70){
      rotateSpeed=1.0;
    }
    else {
      rotateSpeed=defaultRotateSpeed;
    }  
    

    Serial.print("   adjustableSpeed = ");
    Serial.print(adjustableSpeed);
    Serial.print("   speedAdjust=");
    Serial.print(speedAdjust);
    Serial.print("  rotateSpeed=");
    Serial.println(rotateSpeed);
    //playtrk(10,100);

    // Enable alternate brake setting if track 102 exists
    if(checkTrk(10,102)){
      brake00 = true;
    }


    Ps3.attach(notify);
    Ps3.attachOnConnect(onConnect);

    if (!digitalRead(Jumper14)){  // dont change this one, shared spare controller!
          Serial.print("Jumper 14 installed - MAC=00:7f:da:bb:ad:00");
          Ps3.begin("00:7f:da:bb:ad:00");     // 7f Dabba-Doo!
    }
    else{  // put your ps3 controller MAC here!!
          Serial.print("Jumper 14 removed - MAC=00:7f:81:00:02:50");
          Ps3.begin("00:7f:81:00:02:50");
    }

    //Ps3.begin("00:1f:81:00:02:50");

    if (!digitalRead(Button1)){
          Serial.print("Button1 pressed - R2D2 mode");
          RC_mode = R2D2Mode;
          //execute_CMD(0x0F,0,194);
          //playtrk(0,194);
    }
    else{
          Serial.print("Button1 not pressed - Dalek mode");
          RC_mode = DalekMode;
          //execute_CMD(0x0F,0,193);
          //playtrk(0,193);  	// cortana - dalek mode
    }


    Serial.println("Ready.");
    delay(4000);
    pinMode(Motor1a, OUTPUT);
    pinMode(Motor1b, OUTPUT);
    pinMode(Motor2a, OUTPUT);
    pinMode(Motor2b, OUTPUT);

    /*pinMode(speaker, OUTPUT);
    digitalWrite(speaker,LOW); */


    ledcAttach(pwm_M1, pwm_freq, pwm_res);
    ledcWrite(pwm_M1, 0);  // Set duty cycle to 0%

    ledcAttach(pwm_M2, pwm_freq, pwm_res);
    ledcWrite(pwm_M2, 0);  // Set duty cycle to 0%

    ledcAttach(pwm_Gun, pwm_freq, pwm_res);
    ledcWrite(pwm_Gun, 0);  // Set duty cycle to 0%

    ledcAttach(pwm_Ear, pwm_freq, pwm_res);
    ledcWrite(pwm_Ear, 0);  // Set duty cycle to 0%

    // 50Hz for servo
    ledcAttach(pwm_Servo, 50, pwm_res);
    ledcWrite(pwm_Servo, 0);  // Set duty cycle to 0%


    Serial.println("gun LED");
    ledcWrite(pwm_Gun, PWMlow);   // led on
    delay(125);
    ledcWrite(pwm_Gun, PWMmed);   // led on
    delay(125);
    ledcWrite(pwm_Gun, PWMhigh);   // led on
    delay(175);
    ledcWrite(pwm_Gun, PWMoff);   // led on
    delay(100);

  qq=1;
  while(qq--){
    Serial.println("ear LEDs");
    ledcWrite(pwm_Ear, EARlow);   // led on
    delay(125);
    ledcWrite(pwm_Ear, EARmed);   // led on
    delay(125);
    ledcWrite(pwm_Ear, EARhigh);   // led on
    delay(150);
    ledcWrite(pwm_Ear, EARoff);   // led
  }

  // test Servo
  servoPos=1;
  Serial.println("servo Right");
  while(servoPos < 37){
    ledcWrite(pwm_Servo, servoPos);   // send signal to servo
    servoPos=servoPos+1;
    delay(50);
  }
  delay(100);
  Serial.println("servo Left");
  while(servoPos >5){
    ledcWrite(pwm_Servo, servoPos);   // send signal to servo
    delay(50);
    servoPos=servoPos-1;
  }
  delay(100);
  Serial.println("servo Center");
  servoPos=18;
  ledcWrite(pwm_Servo, servoPos);   // center dome
  moving = false;
}





void notify()
{
  
  /*Serial.print("1-upCount=");
  Serial.print(upCount);
  Serial.print("   downCount=");
  Serial.print(downCount);
  Serial.print("   dpad=");
  Serial.print(dpadMode);
  Serial.print("   ps=");
  Serial.print(psMode);
  Serial.print("   servo=");
  Serial.println(servoMode);
  */
      stickX = Ps3.data.analog.stick.lx;
      stickY = Ps3.data.analog.stick.ly;
      setPWM = abs(stickY) * joyUnits + topSpeedOffset;     // forward or reverse speed
      setPWM = int(setPWM * speedAdjust);



        
        // straight forward  -  both motors forward at same speed
        if ((stickX >-25) && (stickX < 25) && (stickY < -20)){
            Serial.print(" Straight Forward  ");
            Serial.print(stickY);
            Serial.println();

            digitalWrite(Motor1a,HIGH);
            digitalWrite(Motor1b,LOW);
            ledcWrite(pwm_M1, setPWM);  

            digitalWrite(Motor2a,HIGH);
            digitalWrite(Motor2b,LOW);
            ledcWrite(pwm_M2, setPWM);   // start moving
            moving = true;
        }

        // forward  and  left  (m2 faster turns left)
        else if ((stickX <= -25) && (stickY < -20)){
            Serial.print(" Forward Left  ");
            Serial.print("  X=");
            Serial.print(stickX);
            Serial.print("  Y=");
            Serial.print(stickY);
            Serial.print("   M2_setPWM =");
            Serial.print(setPWM);
            // turnPWM = (122 + abs(stickX))/2;
            //turnPWM = setPWM -40;     // was 25
            turnPWM = setPWM -45;       // sharper turn
            if (turnPWM < 0)
                turnPWM = 0;
            Serial.print("   turnPWM =");
            Serial.print(turnPWM);
            /*if (turnPWM >= setPWM-1){
              turnPWM = setPWM - 2; */
            /*if (turnPWM >= setPWM-8){
              turnPWM = setPWM - 10;
              Serial.print("   fixed turnPWM =");
              Serial.print(turnPWM);
            }*/
            Serial.println();

            digitalWrite(Motor1a,HIGH);
            digitalWrite(Motor1b,LOW);
            ledcWrite(pwm_M1, turnPWM);
            //ledcWrite(pwm_M1, 0);

            digitalWrite(Motor2a,HIGH);
            digitalWrite(Motor2b,LOW);
            ledcWrite(pwm_M2, setPWM);   // start moving
            moving = true;
        }


        // forward  and  right (m1 faster turns right)
        else if ((stickX >= 25) && (stickY < -20)){
            Serial.print(" Forward Right  ");
            Serial.print("  X=");
            Serial.print(stickX);
            Serial.print("  Y=");
            Serial.print(stickY);
            Serial.print("   M1_setPWM =");
            Serial.print(setPWM);

            turnPWM = setPWM-40;    // was 25
            turnPWM = setPWM -45;
            if (turnPWM < 0)
                turnPWM = 0;

            Serial.print("   turnPWM =");
            Serial.println(turnPWM);

            digitalWrite(Motor1a,HIGH);
            digitalWrite(Motor1b,LOW);
            ledcWrite(pwm_M1, setPWM);   // start moving

            digitalWrite(Motor2a,HIGH);
            digitalWrite(Motor2b,LOW);
            ledcWrite(pwm_M2,turnPWM);
            moving = true;
        } 



        // straight reverse
        else if ((stickY > 20)&&(stickX > -60)&&(stickX < 60)){
            Serial.print(" Straight Reverse  stickY=");
            Serial.print(stickY);
            Serial.print("  X=");
            Serial.println(stickX);

            digitalWrite(Motor1a,LOW);
            digitalWrite(Motor1b,HIGH);
            ledcWrite(pwm_M1, setPWM);   // start moving

            digitalWrite(Motor2a,LOW);
            digitalWrite(Motor2b,HIGH);
            ledcWrite(pwm_M2, setPWM);  
            moving = true;
        }


        // turn in place left
        else if ((stickY >-20) && (stickY < 45) && (stickX < -25)){
            setPWM = abs(stickX) * joyUnits + topSpeedOffset;     // forward or reverse speed
            setPWM = int(setPWM * speedAdjust);
            if ((setPWM < 120))setPWM=setPWM+40;
            Serial.print(" Left pivot   stickX=");
            Serial.print(stickX);
            Serial.print("   joyUnits=");
            Serial.print(joyUnits);
            setPWM = int(setPWM * rotateSpeed);    //rotateSpeed replaced 0.85

            digitalWrite(Motor1a,LOW);    // left
            digitalWrite(Motor1b,HIGH);
            ledcWrite(pwm_M1, setPWM);  
 
            digitalWrite(Motor2a,HIGH);
            digitalWrite(Motor2b,LOW);
            ledcWrite(pwm_M2, setPWM);   // start moving
            moving = true;

            Serial.print("    setPWM=");
            Serial.print(setPWM);
            Serial.print("    new setPWM=");
            Serial.println(setPWM);
        }

        // turn in place right
        else if ((stickY >-20) && (stickY < 45) && (stickX > 25)){
            setPWM = abs(stickX) * joyUnits + topSpeedOffset;     // forward or reverse speed
            setPWM = int(setPWM * speedAdjust);
            if ((setPWM < 120))setPWM=setPWM+40;
            //if ((setPWM < 150)&&(stickX > 90))setPWM=setPWM+40;
            Serial.print(" Right pivot   stickX=");
            Serial.print(stickX);
            Serial.print("    setPWM=");
            Serial.print(setPWM);

            setPWM = int(setPWM * rotateSpeed);    //rotateSpeed replaced 0.85
            Serial.print("    new setPWM=");
            Serial.println(setPWM);

            digitalWrite(Motor1a,HIGH);   // right
            digitalWrite(Motor1b,LOW);
            ledcWrite(pwm_M1, setPWM);  

            digitalWrite(Motor2a,LOW);
            digitalWrite(Motor2b,HIGH);
            ledcWrite(pwm_M2, setPWM);   // start moving
            moving = true;

            Serial.print("    new setPWM=");
            Serial.println(setPWM);
        }


        else if ((stickY >-20) && (stickY < 25) && (stickX >-20) && (stickX < 20) ){
            /* Serial.print(" Stop moving  ");
            Serial.print(stickX);
            Serial.println(); */
            ledcWrite(pwm_M2, 0);  // Set duty cycle to 0%
            ledcWrite(pwm_M1, 0);  // Set duty cycle to 0%
            if (brake00){             // some motor drivers use HIGH to stop and LOW to brake
                digitalWrite(Motor1a,HIGH);
                digitalWrite(Motor1b,HIGH);
                digitalWrite(Motor2a,HIGH);
                digitalWrite(Motor2b,HIGH);
            }
            else{                     // our TB6612FNG uses LOW to stop
                digitalWrite(Motor1a,LOW);
                digitalWrite(Motor1b,LOW);
                digitalWrite(Motor2a,LOW);
                digitalWrite(Motor2b,LOW);
            }
            moving = false;
        }
        if (moving){
            downCount=0;
            crossCount=0;
            upCount=0;
        }
    //--- Digital cross/square/triangle/circle button events ---

    if( Ps3.event.button_down.square )
        Serial.println("Started pressing the square button");
    if( Ps3.event.button_up.square )
        Serial.println("Released the square button");

    if( Ps3.event.button_down.triangle )
        Serial.println("Started pressing the triangle button");
    if( Ps3.event.button_up.triangle )
        playtrk(0,5);
        //Serial.println("Released the triangle button");
    /* if( Ps3.event.button_down.circle ){
        Serial.println("Started pressing the circle button");
                playtrk(0,13);     //exterminate
    } */

    if( Ps3.event.button_down.cross ){
        Serial.println("Started pressing the cross button");
        downCount=0;
        upCount=0;
        gunReset = false;
        gunShooting = true;
        //digitalWrite(gunLED, HIGH); // sets the digital pin 13 on
        ledcWrite(pwm_Gun, PWMhigh);   // led pin13
        gunMillis = millis();
        if(RC_mode == R2D2Mode){
          //playtrk(0,38+mp3_r2d2++);     // R2D2 sequence thru 5 mp3s
          execute_CMD(0x0F,0,38+mp3_r2d2++);
          if(mp3_r2d2 >= 12)
              mp3_r2d2 = 0;
        }
        else if(dpadMode){
          playtrk(0,150 + crossMp3++);    //fart - dpad mode
          if  (crossMp3 > 9) crossMp3=0;
        }
        else if(psMode){
          playtrk(0,160 + crossMp3++);    //fart - PS mode
          if  (crossMp3 > 4) crossMp3=0 ;
        }
        else if(servoMode){
          playtrk(0,140 + crossMp3++);    //fart - servo mode
          if  (crossMp3 > 3)  crossMp3=0;
        }
        delay(200);
    }
        
    if( Ps3.event.button_up.cross ){
        Serial.println("Released the cross button");

        if(adjustableSpeed){
          // Read Speed Adjust Pot
          pot2Value = analogRead(pot2Pin);
          delay(100);
          pot2Value = analogRead(pot2Pin);
          Serial.print("  Pot2 Value=");
          Serial.print(pot2Value);
          speedAdjust = (float)pot2Value/2469.0;
          speedAdjust = (speedAdjust/2.0)+0.16;
        }
        if (speedAdjust<0.70){
            rotateSpeed=1.0;
        }
        else {
            rotateSpeed=defaultRotateSpeed;
        }  
        Serial.print("  speedAdjust=");
        Serial.print(speedAdjust);
        Serial.print("  rotateSpeed=");
        Serial.println(rotateSpeed);
    }


    if( Ps3.event.button_down.circle ){
      
     Serial.println("Started pressing the circle button");
     downCount=0;
     crossCount=0;
     upCount=0;
     if(millis() > mgunMillis+3000){  //wait at least 3 seconds between machine gun blasts
        if(RC_mode == DalekMode){
          playtrk(0,13);
        }
        if(RC_mode == R2D2Mode){
          //playtrk(0,12);     // R2D2 sound
          execute_CMD(0x0F,0,12);
        }
        mgunMillis=millis();
        gunLoop=0;
        while(gunLoop<6){
            chkMillis=millis();
              ledcWrite(pwm_Gun, PWMoff);   // led 
            while (millis()-chkMillis < 122){}
              ledcWrite(pwm_Gun, PWMlow);   // led 
            while (millis()-chkMillis < 126){}
              ledcWrite(pwm_Gun, PWMhigh);   // led 
            while (millis()-chkMillis < 133){}
              ledcWrite(pwm_Gun, PWMlow);   // led  
            while (millis()-chkMillis < 149){}
              ledcWrite(pwm_Gun, PWMmed);   // led 
            while (millis()-chkMillis < 162){}
              ledcWrite(pwm_Gun, PWMhigh);   // led 
            while (millis()-chkMillis < 167){}
              ledcWrite(pwm_Gun, PWMlow);   // led 
            while (millis()-chkMillis < 187){}
              ledcWrite(pwm_Gun, PWMmed);   // led 
            while (millis()-chkMillis < 205){}
              ledcWrite(pwm_Gun, PWMhigh);   // led 
            while (millis()-chkMillis < 211){}
              ledcWrite(pwm_Gun, PWMoff);   // led
            while (millis()-chkMillis < 226){}
              ledcWrite(pwm_Gun, PWMlow);   // led 
            while (millis()-chkMillis < 232){}
              ledcWrite(pwm_Gun, PWMmed);   // led 
            while (millis()-chkMillis < 238){}
              ledcWrite(pwm_Gun, PWMhigh);   // led 
            while (millis()-chkMillis < 258){}
              ledcWrite(pwm_Gun, PWMmed);   // led 
            while (millis()-chkMillis < 272){}
              ledcWrite(pwm_Gun, PWMhigh);   // led 
            while (millis()-chkMillis < 283){}
              ledcWrite(pwm_Gun, PWMmed);   // led 
            while(millis()-chkMillis < 295){}
              ledcWrite(pwm_Gun, PWMlow);   // led 
            while(millis()-chkMillis < 322){}
            ++gunLoop;
        } 
        ledcWrite(pwm_Gun, PWMoff);   // led on
     }
    }

  /*
  Serial.print("2-upCount=");
  Serial.print(upCount);
  Serial.print("   downCount=");
  Serial.print(downCount);
  Serial.print("   dpad=");
  Serial.print(dpadMode);
  Serial.print("   ps=");
  Serial.print(psMode);
  Serial.print("   servo=");
  Serial.println(servoMode);
  */

    //--------------- Digital D-pad button events --------------
    if( Ps3.event.button_down.up){
       Serial.println("Started pressing the up button");
       upPressed=true;
       downCount=0;
       crossCount=0;
       //++upCount;
    }

    if (servoMode){
      // Point dome forward
      if( upPressed && servoPos!=18 ){
        //Serial.println("Still pressing the up button");
        if (servoPos<18)
          ++servoPos;
        if (servoPos>18)
          --servoPos;
        delay(42);
        ledcWrite(pwm_Servo, servoPos);   // send signal to servo
        //Serial.print("servoPos=");
        //Serial.println(servoPos);
      }
    }

    if (upPressed && dpadMode){
        //Serial.print("-^-");
        //execute_CMD(0x0F,0,216);
        upPlayed=false;
    }

    /*
    if( Ps3.event.button_up.up ){
        Serial.println("Released the up button");
        if (upPressed && dpadMode &&(upPlayed==false) && (upCount!=0)){
          Serial.print("-^^ upCount=");
          Serial.print(upCount);
          if (upCount<4)
            execute_CMD(0x0F,0,216);
          upPlayed=true;
        }
        upPressed=false;
        ++upCount;
    }
    */
    if( Ps3.event.button_up.up ){
        Serial.println("Released the up button");
        if (upPressed && dpadMode &&(upPlayed==false) && (upCount<3)){
          //Serial.print("-^^ upCount=");
          //Serial.print(upCount);
          execute_CMD(0x0F,0,216);
          upPlayed=true;
        }
        upPressed=false;
        ++upCount;
    }


    if( Ps3.event.button_down.right ){
        Serial.println("Started pressing the right button");
        rightPressed=true;
        downCount=0;
        crossCount=0;
        upCount=0;
    }
    if (servoMode){
      // Point dome right
      if (servoPos>32)
        servoPos=32;
      if( rightPressed && servoPos!=32 ){
        //Serial.println("Still pressing the right button");
        if (servoPos<32)
          ++servoPos;
        delay(42);
        ledcWrite(pwm_Servo, servoPos);   // send signal to servo
        //Serial.print("servoPos=");
        //Serial.println(servoPos);
      }
    }
    if(rightPressed && (dpadMode||psMode)){     // play the next dpad sound
              Serial.print("->-");
        /*execute_CMD(0x0F,0,201+DPADmp3++);
        if(DPADmp3 > 14)
               DPADmp3 = 0;
        */
        rightPlayed=false;
    }
              

    if( Ps3.event.button_up.right ){
            Serial.println("Released the right button");
            if(rightPressed && dpadMode && (rightPlayed==false)){     // play the next dpad sound
              Serial.print("->>");
              execute_CMD(0x0F,0,201+DPADmp3++);
              if(DPADmp3 > 14)
                  DPADmp3 = 0;
              rightPlayed=true;
            }
            else if(rightPressed && psMode && (rightPlayed==false)){     // play the psmode dpad sound
              Serial.print("->>");
              execute_CMD(0x0F,0,170);
              rightPlayed=true;
            }
            rightPressed=false;
    }

    if( Ps3.event.button_down.down ){
        Serial.println("Started pressing the down button");
        downPressed=true;
        ++downCount;
        crossCount=0;
        upCount=0;

    }



/*  Add this later if it works
    if ( ps3.status.battery >= ps3_status_battery_high )
      print("The controller still has sufficient battery charge")

    if( battery != Ps3.data.status.battery ){
        battery = Ps3.data.status.battery;
        Serial.print("The controller battery is ");
        if( battery == ps3_status_battery_charging )      Serial.println("charging");
        else if( battery == ps3_status_battery_full )     Serial.println("FULL");
        else if( battery == ps3_status_battery_high )     Serial.println("HIGH");
        else if( battery == ps3_status_battery_low)       Serial.println("LOW");
        else if( battery == ps3_status_battery_dying )    Serial.println("DYING");
        else if( battery == ps3_status_battery_shutdown ) Serial.println("SHUTDOWN");
        else Serial.println("UNDEFINED");
    }
*/



    // we get 1 sound in servoMode and psMode
    if(downPressed && ( servoMode || psMode) && downCount==1){     // play the next dpad sound
        downPlayed=false;
    }

    // we get 2 sounds for down button in dpadMode
    if(downPressed && dpadMode && downCount==2){     // play the next dpad sound
        Serial.print("-Dn2");
        downPlayed=false;
    }


    if( Ps3.event.button_up.down ){
           Serial.println("Released the down button");
           if(downPressed && (dpadMode || servoMode || psMode) && (downPlayed==false)){     // play the next dpad sound
              Serial.print("-Dn3");
              if (servoMode)
                  execute_CMD(0x0F,0,220);
              if (dpadMode)
                  execute_CMD(0x0F,0,221+downCount-1);
               if (psMode)
                  execute_CMD(0x0F,0,223);
             downPlayed=true;
            }

            downPressed=false;
    }


  // Toggle between servo and dpad mode if up arrow pressed 12 times
  if (upCount==12){
    if(dpadMode){
      Serial.print("&");
      dpadMode=false;
      servoMode=true;
      psMode=false;
      execute_CMD(0x0F,0,192);    // say servo ready
    }
    else{
      Serial.print("#");
      dpadMode=true;
      servoMode=false;
      psMode=false;
      execute_CMD(0x0F,0,190);    // play PS3 trophy sound
    } 
    upCount=0;
  }

  // Toggle between servo and ps mode if down arrow pressed 12 times
  if (downCount==12){
    if(psMode){
      Serial.print("@");
      dpadMode=false;
      servoMode=true;
      psMode=false;
      execute_CMD(0x0F,0,192);    // say servo ready
    }
    else{
      Serial.print("*");
      dpadMode=false;
      servoMode=false;
      psMode=true;
      execute_CMD(0x0F,0,191);    // say PlayStation
    } 
    downCount=0;
  }



    // Point dome left
    if( Ps3.event.button_down.left){
        Serial.println("Started pressing the left button");
        leftPressed=true;
        downCount=0;
        crossCount=0;
        upCount=0;
    }
    if (servoMode){
      if (servoPos<6)
        servoPos=6;
      if( leftPressed && servoPos!=6){
        //Serial.println("Still pressing the left button");
        if (servoPos>6)
          --servoPos;
        delay(42);
        ledcWrite(pwm_Servo, servoPos);   // send signal to servo
        //Serial.print("servoPos=");
        //Serial.println(servoPos);
      }
    }

    if(leftPressed && (dpadMode||psMode)){     // play the same sound again
            Serial.print("-<-");
            leftPlayed=false;
    }

    if( Ps3.event.button_up.left ){
            Serial.println("Released the left button");
            if(leftPressed && dpadMode && (leftPlayed==false)){     // play the same sound again
              Serial.print("-<<");
              if (DPADmp3==0){
                //playtrk(0,215);
                execute_CMD(0x0F,0,215);
                DPADmp3=14;
                leftPlayed=true;
              }
              else{
                --DPADmp3;
                //playtrk(0,200+DPADmp3);
                execute_CMD(0x0F,0,200+DPADmp3);
                leftPlayed=true;
              }
            }
            else if(leftPressed && psMode && (leftPlayed==false)){    // play the psmode dpad sound
                Serial.print("-<<");
                execute_CMD(0x0F,0,175);
                leftPlayed=true;
             
            } 
            leftPressed=false;
    }

    if( Ps3.event.button_down.ps ){
          Serial.println("Started pressing the Playstation button");
          psPressed=true;
          downCount=0;
          crossCount=0;
          upCount=0;
      Serial.print("-ps-");
          if(RC_mode == R2D2Mode){
              //playtrk(0,11);     // R2D2 PS button
              execute_CMD(0x0F,0,11);
          }
          else if (psMode){
              //playtrk(0,225+PSmp3++);
              execute_CMD(0x0F,0,225+PSmp3++);
              if(PSmp3 >= 5)
                PSmp3 = 0;
          }
          else if (dpadMode){
              //playtrk(0,230+PSmp3++);
              execute_CMD(0x0F,0,230+PSmp3DP++);
              if(PSmp3DP >= 20)
                PSmp3DP = 0;
          }
          else if (servoMode){
              execute_CMD(0x0F,0,224);
          }
          

    }
    if( Ps3.event.button_up.ps ){
        Serial.println("Released the Playstation button");
        psPressed=false;
    }
    //------------- Digital shoulder button events -------------
    if( Ps3.event.button_down.l1 ){
      downCount=0;
      crossCount=0;
      upCount=0;
      if(millis() > extermMillis+3000){  //wait at least 3 seconds between exterminates
        if(RC_mode == DalekMode){
          execute_CMD(0x0F,0,5);
          //playtrk(0,5);
        }
        if(RC_mode == R2D2Mode){
          //playtrk(0,8+mp3_r2d2++);     // R2D2 sequence thru 3 mp3s
          execute_CMD(0x0F,0,8+mp3_r2d2++);
          if(mp3_r2d2 >2)
              mp3_r2d2 = 0;
        }
        //execute_CMD(0x0F,0,5);
        extermMillis=millis();
        // blink ear lights while saying exterminate
        chkMillis=millis();
        delay(39);
          ledcWrite(pwm_Ear, EARmed);   // led 
        while (millis()-chkMillis < 235){}
          ledcWrite(pwm_Ear, EARoff);   // led 
        while (millis()-chkMillis < 353){}
          ledcWrite(pwm_Ear, EARhigh);   // led  
        while (millis()-chkMillis < 454){}
          ledcWrite(pwm_Ear, EARoff);   // led 
        while (millis()-chkMillis < 603){}
          ledcWrite(pwm_Ear, EARmed);   // led 
        while (millis()-chkMillis < 899){}
          ledcWrite(pwm_Ear, EARlow);   // led 
        while (millis()-chkMillis < 982){}
          ledcWrite(pwm_Ear, EARhigh);   // led 
        while (millis()-chkMillis < 1124){}
          ledcWrite(pwm_Ear, EARlow);   // led 
        while (millis()-chkMillis < 1191){}
          ledcWrite(pwm_Ear, EARmed);   // led
        while (millis()-chkMillis < 1600){}
          ledcWrite(pwm_Ear, EARoff);   // led 
        while (millis()-chkMillis < 1700){}
          ledcWrite(pwm_Ear, EARhigh);   // led 
        while (millis()-chkMillis < 1820){}
          ledcWrite(pwm_Ear, EARoff);   // led 
      }

    }
    if (Ps3.data.analog.button.l2==0)
      gunReset = true;

    if (gunShooting && (millis() > gunMillis+550)){
        //digitalWrite(gunLED, LOW);  // shuts LED off
        ledcWrite(pwm_Gun, PWMoff);   // led 

        LED_on = false;
        gunShooting = false;
    }

    if (Ps3.data.analog.button.l2 != 0){
      //Serial.print("Ps3.data.analog.button.l2=");
      //Serial.println(Ps3.data.analog.button.l2);

      if((Ps3.data.analog.button.l2 == 255)&& gunReset && !gunShooting && digitalRead(busyPin)){
        downCount=0;
        crossCount=0;
        upCount=0;
        gunReset = false;
        gunShooting = true;

        ledcWrite(pwm_Gun, PWMhigh);   // gun led pin 27

        gunMillis = millis();
		if(RC_mode == R2D2Mode){
          //playtrk(0,16);     // R2D2 pew gun
          execute_CMD(0x0F,0,16);
		}
		if(RC_mode == DalekMode){
			execute_CMD(0x0F,0,15);
			//playtrk(0,15);
		}
		delay(200);         // not removed 02/13/2025
      }
  /*
  Serial.print("3-upCount=");
  Serial.print(upCount);
  Serial.print("   downCount=");
  Serial.print(downCount);
  Serial.print("   dpad=");
  Serial.print(dpadMode);
  Serial.print("   ps=");
  Serial.print(psMode);
  Serial.print("   servo=");
  Serial.println(servoMode);
  */
    }



}   // end of notify

void onConnect(){
    Serial.println("Connected.");
}


void loop()
{
    if(!Ps3.isConnected())
        return;

}   // end of loop (the loop of mystery)



void playlist(int listNum)
{
  int n=1;
  if (listNum == 11){   //playlist 11 has 19 songs
    while (n < 20){
      playtrk(2,(listNum*10)+n);
      ++n;
    }
  }
  else{
    while (n < 10){     //all other playlists have 9 songs
      playtrk(2,(listNum*10)+n);
      ++n;
    }
  }
}


int checkTrk(int folder, int track)
{
    while (digitalRead(busyPin)==busy)
    {
        // wait here for last track to finish playing
    }
    playtrk(folder,track);
    Serial.println("checkTrk-  PLAY command sent");
    delay(30);
    Serial.print("track ");
    Serial.print(folder);
    Serial.print(",");
    Serial.print(track);

    qqqq=0;
    while (qqqq++ < 4 && digitalRead(busyPin)!=busy){
      if(digitalRead(busyPin)==busy){     // LOW = busy playing MP3
        Serial.println(" FOUND");
        while (digitalRead(busyPin)==busy)
        {
          // wait here for track to finish playing
        }
        return 1;
      }
      //delay(20);
      delay(100);
    }
    if(digitalRead(busyPin)==busy){
      Serial.println(" FOUND");
      while (digitalRead(busyPin)==busy)
      {
          // wait here for track to finish playing
      }
      return 1;
    }
    Serial.println(" NOT found");
    return 0;
}
// ------------------------------------------------------------------------------------





/*  play one specified audio track
 *  
 *  dont exit until track is finished  - monitor busy pin 10 on dfPlayer
 *  if track is less than 2.5 seconds, set tooShort=true
 *  POWER BUTTON or STOP to stop song
 *  
*/

void playtrk(int folder, int track)
{
    int nnn;

    
    Volume = analogRead(volumePin);   //pot range  0 to 4095
    dfVolume = int(Volume/136);
    volume_CMD(0x06,0,dfVolume);  //set volume
    lastVolume=dfVolume;
    
    
    Serial.print("\n-PLAYTRK-");
    Serial.print("  mp3Busy=");
    Serial.print(mp3Busy);
    Serial.print("  dfVolume =");
    Serial.print(dfVolume);
    Serial.print("  folder =");
    Serial.print(folder);
    Serial.print("  track =");
    Serial.print(track);
    if(digitalRead(busyPin)==busy){     // LOW = busy playing MP3
      mp3Busy=true;
    } else {
      mp3Busy=false;
    }
      Serial.print("  mp3Busy(PT0) =");
      Serial.println(mp3Busy);
   
    tooShort=false;

   /*
    if(digitalRead(busyPin)==busy){     // LOW = busy playing MP3
      mp3Busy=true;
    } else {
      trackMillis = millis();
      execute_CMD(0x0F,folder,track);    // play mp3
      delay(1100);  //sometimes it takes this long to start playing
    }
    */
          execute_CMD(0x0F,folder,track);    // play mp3

    if(digitalRead(busyPin)==busy){     // LOW = busy playing MP3
      mp3Busy=true;
    } else {
      mp3Busy=false;
    }

      /* Serial.print("mp3BusyPT1 =");
      Serial.println(mp3Busy);
      */ 

    /*
    while((mp3Busy == 0)&&(IRescFlag==false)){
       volume = analogRead(volumePin)/33;
      if (volume == 30){
        volume=31;
      }
      if (volume != lastVolume){
        //Serial.println(volume);
        execute_CMD(0x06,0,volume);  //set volume
        lastVolume = volume;
      } 

      if(digitalRead(busyPin)==busy){     // LOW = busy playing MP3
        mp3Busy=true;
      } else {
        mp3Busy=false;
      }

    }
    */

    Serial.println("END OF PLAYTRK--------");
}



// MP3 DFplayer mini Excecute the command and parameters
void execute_CMD(byte CMD, byte Par1, byte Par2)
{
    Serial.print(" execute_CMD  \n");

  // Build the command line - no checksum
  byte Command_line[8] = { Start_Byte, Version_Byte, Command_Length, CMD, Acknowledge,
  Par1, Par2, End_Byte};


  //Send the command line to the module
  for (byte k=0; k<8; k++)
  {
    Serial.print(Command_line[k]);
    Serial.print(" ");
    SerialDF.write( Command_line[k]);
  }
  // wakeupMillis=millis()+600000; //10 minutes
  Serial.println();
}

// MP3 DFplayer mini Excecute the command and parameters
void volume_CMD(byte CMD, byte Par1, byte Par2)
{
    Serial.print(" volume_CMD  \n");
  // Calculate the checksum (2 bytes)
  word checksum = -(Version_Byte + Command_Length + CMD + Acknowledge + Par1 + Par2);
  // Build the command line
  //byte Command_line[10] = { Start_Byte, Version_Byte, Command_Length, CMD, Acknowledge,
  //Par1, Par2, highByte(checksum), lowByte(checksum), End_Byte};
  byte Command_line[8] = { Start_Byte, Version_Byte, Command_Length, CMD, Acknowledge,
  Par1, Par2, End_Byte};
  //Send the command line to the module
  for (byte k=0; k<8; k++)
  {
    Serial.print(Command_line[k]);
    Serial.print(" ");
    SerialDF.write( Command_line[k]);
  }
  // wakeupMillis=millis()+600000; //10 minutes
  Serial.println();
}



